library(memisc)
library(mestats)

load("voteint-classd-churchat-cmp.RData")

voteint.classd.churchat.work <- subset(voteint.classd.churchat.cmp,
    as.numeric(classd) %in% 1:4 &
                    nation %in% c(
                              "France",
                              "Belgium",
                              "Netherlands",
                              "Germany West",
                              "Italy",
                              "Danmark",
                              "Great Britain"
                              ) &
                    year > 1974 #& year <= 1994
                    & (! (nation == "Italy" & year > 1992) )
)

voteint.classd.churchat.work <- within(voteint.classd.churchat.work,{
      choice.set <- interaction(classd,churchat,eb,nation)
      Time <- (year - min(year))/(max(year)-min(year)) - .5
    })

mclogit.classd.churchat <- mclogit(cbind(Freq,choice.set)~
                I(econdim^2)+I(authlib^2)+I(tradmod^2)+
                econdim/((churchat+classd)*Time)+
                authlib/((churchat+classd)*Time)+
                tradmod/((churchat+classd)*Time),
         data=voteint.classd.churchat.work,
         random=~1|party/eb
         )

summary(mclogit.classd.churchat)

save(mclogit.classd.churchat,file="mclogit-classd-churchat.RData")
